# R graphic Device 실행
x11()

# 2 X 3으로 화면 분할하기
par(mfrow = c(2,3))

# type옵션을 다르게 하면서 plot() 실행하기
plot(0:6, 0:6, main="default")
plot(0:6, 0:6, type="b", main="type = \"b\"")
plot(0:6, 0:6, type="c", main="type = \"c\"")
plot(0:6, 0:6, type="o", main="type = \"o\"")
plot(0:6, 0:6, type="s", main="type = \"s\"")
plot(0:6, 0:6, type="S", main="type = \"S\"")








par(mfrow=c(1,1))
# 막대그래프로 나타낼 객체 만들기
x <- c(38, 52, 24, 8, 3)
barplot(x)

# x 변수 이름 설정하기
names(x) <- c("Excellent", "Very Good", "Good", "Fair", "Poor")
barplot(x)


# 객체만들기 2
y <- scan()
# Console창에 직접 입력
# 1 2 3 3 4 3 4 1 5 3 3 3 2 4 4 
# 3 4 3 5 3 1 2 3 3 4 4 3 2 3 4  
barplot(y)

# table 함수를 사용하여 범주화하기
barplot(table(y), xlab = "Beverage", ylab = "Frequency")

# 비율로 나타내기
barplot(table(y)/length(y), xlab = "Beverage", ylab = "Proportion")

# 객체만들기 3
sales <- c(45, 44, 46)
names(sales) <- c("Park", "Kim", "Lee")
barplot(sales, main = "Sales", ylab = "Thousands")

# 범위 조절하기
barplot(sales, main = "Sales", ylab = "Thousands", ylim = c(42,46), xpd = FALSE)




# 데이터 불러오기
score <- read.table("score.txt", header=T)
View(score)
# 파이차트 그리기
pie(score$국어, labels = paste(score$성명, "-", score$국어), col = rainbow(10), clockwise = TRUE)

# 두줄로 된 label 나태내기 
pie(score$국어, labels = paste(score$성명, "\n", "(",score$국어,")"), col = rainbow(10), clockwise = TRUE)

## googleVis 패키지 사용하기
install.packages("googleVis")
library(googleVis)

# 색상 설정
buildcolors <- function(color_count){
  colors <- rainbow(color_count)
  colors <- substring(colors, 1, 7) 
  colors <- paste(colors, collapse="','")
  colors <- paste("'", colors, "'", sep="")
  colors <- paste("[", colors, "]", sep="")
  return(colors)
}

cols <- buildcolors(10)

# 파이 차트 구현하기
# 인터넷 익스플로어에서 실행
pie <- gvisPieChart(data.frame(score$성명, score$국어), 
                    option = list(width=600, height=600, title="국어성적", 
                                  colors= cols, pieSliceText="label", pieHole=0.5), chartid="donut")
plot(pie)

# 3D 파이 차트 만들기
pie2 <- gvisPieChart(data.frame(score$성명,score$국어), 
                     option=list(width=600, height=600, title="국어성적",
                                 colors=cols, pieSliceText="value", pieHole=0.5, is3D=TRUE), chartid="donut")
plot(pie2)


# 버블 차트 
library(googleVis)
Fruits
bubble <- gvisBubbleChart(Fruits, idvar="Fruit", xvar="Sales", yvar="Expenses", colorvar="Year", 
                          sizevar="Profit", options=list(height=600, weight=200))
plot(bubble)


# x 변수 벡터 만들기
Year <- 2013:2018

# SK 시즌별 승률
SK <- c(0.496, 0.484, 0.486, 0.479, 0.524, 0.650) 

# 한화 시즌별 승률
HanHwa <- c(0.331, 0.389, 0.472, 0.468, 0.430, 0.564) 

# 넥센 시즌별 승률
Nexen<- c(0.571, 0.619, 0.545, 0.538, 0.486, 0.476)

# y 변수 데이터 프레임 만들기
Winning_Rate <- data.frame(SK, HanHwa, Nexen)
x11()
# 그래프로 나타내기
matplot(Year, Winning_Rate, type='o', 
        pch=c(1,2,3), col=c("red","green", "blue","black"))

# legend 함수로 범례 추가하기
Team=c("SK", "HanHwa", "Nexen")
legend("top", Team,col=c("red","green","blue"), 
       pch=c(1,2,3), title="시즌별 승률")










# R 내장 cars 데이터
cars
cars[1:4,]

#회귀 모형 적합
z <- lm(dist ~ speed, data = cars)
summary(z)

# cars 데이터를 산점도로 나타내기
x11()
par(mfrow=c(1,1))
plot(cars, main = "abline")

# horizontal
abline(h = 20)
abline(h = 30)

# vertical
abline(v = 20, col = 'blue')

# y = a + bx
abline(a = 40, b = 4, col = 'red')

# reg 인수
abline(z, lty = 2, lwd = 2, col = 'green')

# coef 인수
abline(z$coef, lty = 3, lwd = 2, col = 'red')










# R graphic Device 실행하기
x11()

# type 을 no plotting으로 설정하여 plot 표현하기
plot(1:10, type= "n", xlab="", ylab="", main="legend")

# 위치를 나타내는 용어로 범례 나타내기
legend("bottomright","(x,y)", pch=1, title="bottomright")
legend("bottom","(x,y)", pch=1, title="bottom")
legend("bottomleft","(x,y)", pch=1, title="bottomleft")
legend("left","(x,y)", pch=1, title="left")
legend("topleft","(x,y)", pch=1, title="topleft")
legend("top","(x,y)", pch=1, title="top")
legend("topright","(x,y)", pch=1, title="topright")
legend("right","(x,y)", pch=1, title="right")
legend("center","(x,y)", pch=1, title="center")
legends <- c("Legend1","Legend2")

# x,y 좌표를 통해서 범례 나타내기
legend(3,8, legend = legends, pch=1:2, col=1:2)
legend(7,8, legend = legends, pch=1:2, col=1:2, lty=1:2)
legend(3,4, legend = legends, fill=1:2)
legend(7,4, legend = legends, fill=1:2, density=30)










# ggplot2 패키지 설치하기
install.packages("ggplot2")
library(ggplot2)

# 1단계 배경설정(축)
ggplot(data=mpg, aes(x <- displ, y <- hwy))

# 배경에 산점도 추가
ggplot(data=mpg, aes(x = displ, y = hwy)) + geom_point()

# x축 범위 3~6으로 지정
ggplot(data=mpg, aes(x = displ, y = hwy)) + geom_point() + xlim(3,6)

# x축 범위 3~6, y축 범위 10~30으로 지정
ggplot(data=mpg, aes(x = displ, y = hwy)) + geom_point() + xlim(3,6) + ylim(10,30)











# 데이터 전처리 패키지 설치
install.packages("dplyr")
library(dplyr)

# mpg 데이터를 drv로 분류하고 hwy평균으로 요약
df_mpg <- mpg %>% group_by(drv) %>% 
  summarise(mean_hwy = mean(hwy))
df_mpg

# geom_col()으로 범주의 크기를 표현
ggplot(data = df_mpg, aes(x = drv, y = mean_hwy)) + geom_col()

# reorder를 사용하여 범주를 크기순으로 정렬
ggplot(data = df_mpg, aes(x=reorder(drv, -mean_hwy), y = mean_hwy)) + geom_col()

# 막대 그래프로 표현하기
ggplot(data=mpg, aes(x=drv)) + geom_bar()
ggplot(data=mpg, aes(x=hwy)) + geom_bar()

# 선그래프 - 시간에 따라 달라지는 데이터 표현하기
ggplot(data = economics, aes(x = date, y = unemploy)) + geom_line()

# 상자그림 - 집단 간 분포 차이 표현하기
ggplot(data = mpg, aes(x = drv, y = hwy)) + geom_boxplot()












# 필요한 패키지 #gglot2, dplyr, ggmap
install.packages("ggmap")
library(ggmap)
library(dplyr)

# 데이터 불러오기
data <- read.csv("subway.csv", header=T)
head(data)

# 필요한 열 뽑아내기 (전처리 작업)
data2 <- data[,c(2,3,8,9)]
colnames(data2) <- c("전철역명","호선","x좌표","y좌표")
head(data2)

# 2호선만 추출하기
s_2 <- data2 %>% filter(호선=='2')
head(s_2)
str(s_2)

# 3호선만 추출하기
s_3 <- data2 %>% filter(호선=='3') 
head(s_3)
str(s_3)

# get_map을 이용하여 지도 받아오기
center <- c(mean(s_2$y좌표), mean(s_2$x좌표))
seoul <- get_map(center, zoom=11, maptype="roadmap")

# R Graphic Device
x11()
ggmap(seoul)

# 지도에 2호선 표시하기
ggmap(seoul) + geom_point(data=s_2, 
                          aes(x=y좌표, y=x좌표), 
                          size=2.5,
                          alpha=0.7,#투명도조절
                          col="green") +
  geom_text(data=s_2, aes(x=y좌표, y=x좌표+0.005,
                          label=전철역명),
            size=2.4) #label : 지도에 역명표시

# 2, 3호선 같이 표시하기
ggmap(seoul) + geom_point(data=s_2, 
                          aes(x=y좌표, y=x좌표), 
                          size=2.5,
                          alpha=0.7,
                          col="green") +
  geom_point(data=s_3, aes(x=y좌표, y=x좌표),
             size=2.5, alpha=0.7, col='orange') +
  geom_text(data=s_2, aes(x=y좌표, y=x좌표+0.005, label=전철역명),
            size=2.4)+
  geom_text(data=s_3, aes(x=y좌표, y=x좌표+0.005, label=전철역명),
            size=2.8) #label : 지도에 역명표시



