## Kaggle FIFA Data Visualization
library(tidyverse)
options(repr.plot.width=8, repr.plot.height=4)
mypink = "#f442b3"
myblue = "#42d4f4"

fifa18 <- read_csv('FIFA.csv', col_types = cols())

fifa18$bpp2 <- 100 - fifa18$`Ball Possession %`
fifa18$bpp_diff <- fifa18$`Ball Possession %` - fifa18$bpp2

#Total Teams
cat("Total Teams: ",length(unique(fifa18$Team)),"\n")
#cat(paste(fifa18$Team,collapse = "\n"))
unique(fifa18$Team)

# Which Team in which Match had the maximum ball possession?
fifa18  %>% 
  #select(Team,`Ball Possession %`)  %>% 
  arrange(desc(`Ball Possession %`))  %>% 
  mutate(Team = reorder(Team,`Ball Possession %`))  %>% 
  head(1)  %>% 
  select(Date:`Ball Possession %`)

# Which mactch had the closest fight in terms of Ball Possession %?
fifa18  %>% 
  #select(Team,`Ball Possession %`)  %>% 
  arrange(abs(bpp_diff))  %>%
  head(1)

# Fouls, Fouls, Fouls
fifa18  %>% 
  group_by(Team)  %>% 
  summarise(`Total Fouls Committed` = sum(`Fouls Committed`))  %>% 
  arrange(desc(`Total Fouls Committed`))  %>% 
  mutate(Team = reorder(Team, `Total Fouls Committed`))  %>% 
  head(10) %>% 
  ggplot() + geom_bar(aes(Team,`Total Fouls Committed`), stat = "identity",fill = mypink) +
  labs(title = "More Fouls") +
  coord_flip() -> p1

fifa18  %>% 
  group_by(Team)  %>% 
  summarise(`Total Fouls Committed` = sum(`Fouls Committed`))  %>% 
  arrange(desc(`Total Fouls Committed`))  %>% 
  mutate(Team = reorder(Team, -`Total Fouls Committed`))  %>% 
  tail(10) %>% 
  ggplot() + geom_bar(aes(Team,`Total Fouls Committed`), stat = "identity",  fill = myblue) +
  labs(title = "Less Fouls") +
  coord_flip() -> p2

cowplot::plot_grid(p1,p2)

# Just looking for Correlation!
options(repr.plot.width=10, repr.plot.height=4)

library(corrplot) 

fifa18  %>% 
  select_if(is.numeric)  %>% 
  drop_na()  %>% 
  cor()  %>% 
  corrplot(type = "upper", method ="square", tl.cex  = 0.5)

# Relationship between Goals and Passes
fifa18  %>% 
  group_by(Team)  %>% 
  summarise(`Total Passes` = sum(Passes),
            `Total Goals` = sum(`Goal Scored`))  %>% 
  ggplot(aes(`Total Passes`,`Total Goals`)) + geom_jitter(alpha = 1/4) +
  geom_smooth()

# Goals~Passes Relationship by Team
options(repr.plot.width=10, repr.plot.height=8)
fifa18  %>% 
  ggplot(aes(`Goal Scored`,Passes)) + geom_jitter(alpha = 1/4) +
  facet_wrap(~ Team, ncol = 8) +
  stat_smooth(method="lm",se = F)

# Distance Covered vs Passes
options(repr.plot.width=10, repr.plot.height=4)
fifa18  %>% 
  ggplot(aes(`Distance Covered (Kms)`,Passes)) + geom_jitter(alpha = 1/4) +
  #facet_wrap(~ Team, ncol = 8) +
  stat_smooth()

options(repr.plot.width=10, repr.plot.height=4)
fifa18  %>% 
  ggplot(aes(`Distance Covered (Kms)`,`Goal Scored`)) + geom_jitter(alpha = 1/4) +
  #facet_wrap(~ Team, ncol = 8) +
  stat_smooth()

# Ball Possession % vs Goals Scored
options(repr.plot.width=10, repr.plot.height=4)
fifa18  %>% 
  ggplot(aes(`Ball Possession %`,`Goal Scored`)) + geom_jitter(alpha = 1/4) +
  #facet_wrap(~ Team, ncol = 8) +
  stat_smooth()

options(repr.plot.width=10, repr.plot.height=8)
fifa18  %>% 
  ggplot(aes(`Ball Possession %`,`Goal Scored`)) + geom_jitter(alpha = 1/4) +
  facet_wrap(~ Team, ncol = 8) +
  stat_smooth(method = 'lm')

# More Attempts - Less Attempts
fifa18  %>% 
  group_by(Team)  %>% 
  summarise(`Total Fouls Committed` = sum(Attempts))  %>% 
  arrange(desc(`Total Fouls Committed`))  %>% 
  mutate(Team = reorder(Team, `Total Fouls Committed`))  %>% 
  head(10) %>% 
  ggplot() + geom_bar(aes(Team,`Total Fouls Committed`), stat = "identity",fill = mypink) +
  labs(title = "More Attempts",
       y = "Attempts count") +
  coord_flip() -> p1

fifa18  %>% 
  group_by(Team)  %>% 
  summarise(`Total Fouls Committed` = sum(Attempts))  %>% 
  arrange(desc(`Total Fouls Committed`))  %>% 
  mutate(Team = reorder(Team, -`Total Fouls Committed`))  %>% 
  tail(10) %>% 
  ggplot() + geom_bar(aes(Team,`Total Fouls Committed`), stat = "identity",  fill = myblue) +
  labs(title = "Less Attempts",
       y = "Attempts count") +
  coord_flip() -> p2

cowplot::plot_grid(p1,p2)

